/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.compras;

import ec.gob.sri.dimm.api.modelo.validacion.ContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Comprobante;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ComprobanteRetencion
extends Comprobante {
    private static final long serialVersionUID = -1317427326249457018L;
    private String tagEstablecimiento;
    private String tagEmision;
    private String tagSecuencial;
    private String tagAutorizacion;
    private String tagFechaEmision;
    private boolean transaccionCompra;

    public ComprobanteRetencion() {
        this.tagEstablecimiento = "estabRetencion1";
        this.tagEmision = "ptoEmiRetencion1";
        this.tagSecuencial = "secRetencion1";
        this.tagAutorizacion = "autRetencion1";
        this.tagFechaEmision = "fechaEmiRet1";
        this.transaccionCompra = true;
    }

    public ComprobanteRetencion(String tagEstablecimiento, String tagEmision, String tagSecuencial, String tagAutorizacion, String tagFechaEmision) {
        this.tagEstablecimiento = tagEstablecimiento;
        this.tagEmision = tagEmision;
        this.tagSecuencial = tagSecuencial;
        this.tagAutorizacion = tagAutorizacion;
        this.tagFechaEmision = tagFechaEmision;
        this.transaccionCompra = false;
    }

    @Override
    public ComprobanteRetencion crearCopiaEdicion() {
        ComprobanteRetencion copia = new ComprobanteRetencion();
        copia.setEstablecimiento(super.getEstablecimiento());
        copia.setPuntoEmision(super.getPuntoEmision());
        copia.setSecuencial(super.getSecuencial());
        copia.setNumAutorizacion(super.getNumAutorizacion());
        copia.setFechaEmision(super.getFechaEmision());
        copia.setObligatorio(super.isObligatorio());
        copia.setTransaccionCompra(this.transaccionCompra);
        return copia;
    }

    @Override
    public void actualizarInformacion(Comprobante copiaEdicion) {
        super.actualizarInformacion(copiaEdicion);
    }

    @Override
    protected ResultadoValidacion validarFechaEmision(ResultadoValidacion resultado) {
        Iva iva = (Iva)this.getRaizModelo();
        boolean esMicroEmpresa = iva.getDatosDeclaracion().isEsMicroEmpresa();
        if (this.transaccionCompra) {
            ContextoValidacion ctx = this.getContextoValidacion();
            if (esMicroEmpresa) {
                Date fechaComprobante = (Date)ctx.obtener("FECHA_COMPROBANTE");
                SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
                if (!Util.isFechaMayorIgual(this.getFechaEmision(), fechaComprobante)) {
                    return resultado.fallarValidacion(String.format("La fecha de %s debe ser %s a la fecha del comprobante de venta %s para microempresas", "emisi\u00f3n Comprobante", "mayor o igual", formatter.format(fechaComprobante)));
                }
            } else {
                Date fechaCompro = (Date)ctx.obtener("FECHA_COMPROBANTE");
                if (!Util.isFechaMayorIgual(this.getFechaEmision(), fechaCompro)) {
                    return resultado.fallarValidacion("La Fecha de Emisi\u00f3n del Comprobante de Retenci\u00f3n debe ser mayor o igual a la Fecha de Emisi\u00f3n del Comprobante de Venta (" + Constantes.FORMATO_FECHA.format((Date)ctx.obtener("FECHA_COMPROBANTE")) + ")");
                }
            }
        } else if (!Util.isFechaMayorIgualPeriodoMesAnio(this.getFechaEmision(), iva.getFechaPeriodoDeclarado())) {
            return resultado.fallarValidacion(String.format("La fecha de %s debe ser %s a la fecha del per\u00edodo informado", "emisi\u00f3n", "mayor o igual"));
        }
        return resultado;
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName(this.tagEstablecimiento);
        Element eValor = (Element)valorList.item(0);
        this.setEstablecimiento(eValor.getTextContent());
        if (!"000".equals(this.getEstablecimiento())) {
            this.setObligatorio(true);
            valorList = elemento.getElementsByTagName(this.tagEmision);
            eValor = (Element)valorList.item(0);
            this.setPuntoEmision(eValor.getTextContent());
            valorList = elemento.getElementsByTagName(this.tagSecuencial);
            eValor = (Element)valorList.item(0);
            this.setSecuencial(eValor.getTextContent());
            valorList = elemento.getElementsByTagName(this.tagAutorizacion);
            eValor = (Element)valorList.item(0);
            this.setNumAutorizacion(eValor.getTextContent());
            valorList = elemento.getElementsByTagName(this.tagFechaEmision);
            eValor = (Element)valorList.item(0);
            this.setFechaEmision(Util.importarFecha(eValor));
        }
        return this;
    }

    public boolean isTransaccionCompra() {
        return this.transaccionCompra;
    }

    public void setTransaccionCompra(boolean transaccionCompra) {
        this.transaccionCompra = transaccionCompra;
    }
}

